#include <cstdio>
#include <hal/drivers/flash.h>
#include <hal/devices.h>
#include <hal/drivers/pwm.h>

int cmd_setuptime(int argc, char *argv[])
{
	if (argc != 2)
	{
		printf("%s: error, syntax: ADDRESS %s SETUP_TIME\n\n", argv[0], argv[0]);
	}
	else
	{
		pwm_file pwm;
		pwm.setup = -1;

		sscanf(argv[1], "%f", &pwm.setup);

		if (pwm.setup <= configure_file.max_setup && pwm.setup >= configure_file.min_setup)
		{
			flash_file * p_flash_file;

			fseek(p_pwm, (int) (&pwm.setup) - (int) (&pwm), SEEK_SET);
			fwrite(&pwm.setup, sizeof(pwm_file::setup), 1, p_pwm);
			fflush(p_pwm);

			decltype(p_flash_file->setup) setup = pwm.setup;
			fseek(p_flash, (int) (&p_flash_file->setup) - (int) (p_flash_file), SEEK_SET);
			fwrite(&setup, sizeof(flash_file::setup), 1, p_flash);
			fflush(p_flash);

			printf("%s: the setup time is set to: %f%%\n\n", argv[0], pwm.setup);
		}
		else
		{
			printf("%s: error, setup time: %s is not in range: %f~%f\n\n", argv[0], argv[1], configure_file.min_setup,
			    configure_file.max_setup);
		}
	}

	fflush(stdout);
}
